/*****************************************************************************
 *   main.h: Header file for the main FOC program
 *
 *   Copyright(C) 2009, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2009.11.25  ver 1.00    Preliminary version, first Release
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 *****************************************************************************/
 
#ifndef __MAIN_H__
#define __MAIN_H__

#define BUTTON !(GPIO2_PINS&(1<<26))

// Function prototypes
void Call_100ms(void);
void Call_1s(void);
void ProcessUart(void);
void EEPROM_ReadEEparam(PARAM_STRUCT *param);
void EEPROM_WriteEEparam(PARAM_STRUCT *param);
void CopyFOCToEEparam(void);
void CopyEEparamToFOC(void);
signed long UartDataToSL(void);
unsigned short UartDataToUS(void);
void GetDeviceID(volatile DWORD *deviceID);
void CopyFOCStruct(FOC_STRUCT *dest, FOC_STRUCT *src, size_t count);

#endif  /* __MAIN_H__ */
